<?php
App::uses('AppController', 'Controller');
/**
 * Applicantinformations Controller
 *
 * @property Applicantinformation $Applicantinformation
 * @property PaginatorComponent $Paginator
 * @property FileUploadComponent $FileUpload
 */
class ApplicantinformationsController extends AppController {
	
	public $uses = array('Applicantinformation','Applicanteducation');

/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator', 'FileUpload');
	
	public function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow('add');
	}

/**
 * add method
 *
 * @return void
 */
	public function add() {
		
		$this->layout = 'inner';
		
		if ($this->request->is('post')) {
			
			//Check here the File image array is empty or not
			if($this->request->data['Applicantinformation']['photo']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."photo";
				$target_path_for_database ="files"."/"."photo/";
				$filename = $this->request->data['Applicantinformation']['photo']['name'];
				$tmpname  = $this->request->data['Applicantinformation']['photo']['tmp_name'];
				$filesize = $this->request->data['Applicantinformation']['photo']['size'];
				$filetype = $this->request->data['Applicantinformation']['photo']['type'];							
				$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg');				
				if(strlen($filename) > 0){
					$this->request->data['Applicantinformation']['image'] = $target_path_for_database.$filename;						
				}					
				
			}//End
			
			$this->Applicantinformation->create();
			if ($this->Applicantinformation->save($this->request->data['Applicantinformation'])) {
				
				$std = $this->Applicantinformation->getLastInsertID();
				$education = array();
				$i = 0;
				foreach($this->data['Applicanteducation'] as $value){
					$education[$i]['applicantinformation_id']= $std;
					$education[$i]['nameofexam'] = $value['nameofexam'];					
					$education[$i]['result']= $value['result'];
					$education[$i]['subject']= $value['subject'];
					$education[$i]['institution_name'] = $value['institution_name'];					
					$education[$i]['board']= $value['board'];
					$education[$i]['passingyear'] = $value['passingyear'];
					$i+=1;
				}
						
				$this->Applicanteducation->create();
				$this->Applicanteducation->saveAll($education);
				
				
				$this->Session->setFlash(__('The applicantinformation has been saved.'), 'default', array('class' => 'alert alert-success'));
				return $this->redirect(array('action' => 'add'));
			} else {
				$this->Session->setFlash(__('The applicantinformation could not be saved. Please, try again.'), 'default', array('class' => 'alert alert-danger'));
				return $this->redirect(array('action' => 'add'));
			}
		}
	}

/**
 * admin_index method
 *
 * @return void
 */
	public function admin_index() {
		$this->Applicantinformation->recursive = 0;
		$this->set('applicantinformations', $this->Applicantinformation->find('all',array('order'=>array('Applicantinformation.created'=>'DESC'))));
	}

/**
 * admin_view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_view($id = null) {
		$this->layout = 'print';
		$this->set('title_for_layout','Applicant Information Detail');
		if (!$this->Applicantinformation->exists($id)) {
			throw new NotFoundException(__('Invalid applicantinformation'));
		}
		$options = array('conditions' => array('Applicantinformation.' . $this->Applicantinformation->primaryKey => $id));
		$this->set('applicantinformation', $this->Applicantinformation->find('first', $options));
	}

/**
 * admin_delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_delete($id = null) {
		$this->Applicantinformation->id = $id;
		if (!$this->Applicantinformation->exists()) {
			throw new NotFoundException(__('Invalid applicantinformation'));
		}
		
		$filename = $this->Applicantinformation->find('first',array('conditions'=>array('Applicantinformation.id'=>$id),'fields'=>array('Applicantinformation.image')));
		if(!empty($filename['Applicantinformation']['image'])){
			if(unlink($filename['Applicantinformation']['image'])){
				if ($this->Applicantinformation->delete()) {
					$this->Session->setFlash(__('The Applicantinformation has been deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->Applicantinformation->delete()) {
					$this->Session->setFlash(__('The Applicantinformation has been deleted.', true));
					$this->redirect(array('action'=>'index'));
				}	
			}
		}else{
			if ($this->Applicantinformation->delete()) {
				$this->Session->setFlash(__('The Applicantinformation has been deleted.', true));
				$this->redirect(array('action'=>'index'));
			}	
		}
		
		$this->Session->setFlash(__('Applicantinformation was not deleted', true));
		$this->redirect(array('action' => 'index'));
		
	}
}