<?php
class CoCurricularActivitiesController extends AppController {
	
	var $name = 'CoCurricularActivities';
	public $components = array('Paginator','FileUpload');
	
	function beforeFilter(){
		parent::beforeFilter();
		$this->Auth->allow('download');
	}

	function index() {
		$this->layout = 'inner';
		$this->CoCurricularActivity->recursive = 0;									
		$this->paginate = array('conditions' => array('CoCurricularActivity.isactive' => 1),'order' => array('CoCurricularActivity.order'=>'ASC'),'limit'=>10);	
		$this->set('newses', $this->Paginator->paginate());
	}

	function view($id = null) {
		$this->layout = 'inner';
		if (!$id) {
			$this->Session->setFlash(__('Invalid CoCurricularActivity', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('news', $this->CoCurricularActivity->read(null, $id));
	}
	
	public function download($id = null) {
	
		$this->layout='ajax';
		if(!empty($id)){
		$file_id = $id;
		$downloadfile = $this->CoCurricularActivity->read(null, $file_id);   
		$path = Configure::read("files"."/"."news/");           
		$fileName = $downloadfile['CoCurricularActivity']['attach_file'];
		//debug($path); exit;
		header('Content-Description: File Transfer');
		header('Content-Type: application/octet-stream');
		header('Content-Disposition: attachment; filename='.basename($fileName));
		header('Content-Transfer-Encoding: binary');
		header('Expires: 0');
		header('Cache-Control: must-revalidate');
		header('Pragma: public');
		header('Content-Length: ' . filesize($path.$fileName));
		//ob_clean();
		flush();
		readfile($path.$fileName);
		exit;
		}
	}
	
	function admin_index() {
		$this->layout = 'default';
		$this->CoCurricularActivity->recursive = 0;
		$this->paginate = array('order'=>'CoCurricularActivity.created DESC');
		$this->set('newses', $this->Paginator->paginate());
	}
    
    function admin_updateneworder($id,$order)
    {
          $this->layout = "ajax";
          $data = array('CoCurricularActivity' => array( 'id'=> $id,'order'=>$order));   
           
        $this->CoCurricularActivity->save($data);       
        $this->set('rowid', $id );
        $this->set('orderofrow', $order );     
    }

	function admin_add() {
		
		$this->layout = 'default';
		if (!empty($this->request->data)) {
			//Check here the File image array is empty or not
				if($this->request->data['CoCurricularActivity']['attachfile']['name'] != null){				
					$target_path = WWW_ROOT."files".DS."news";
					$target_path_for_database ="files"."/"."news/";
					$filename = $this->request->data['CoCurricularActivity']['attachfile']['name'];
					$tmpname  = $this->request->data['CoCurricularActivity']['attachfile']['tmp_name'];
					$filesize = $this->request->data['CoCurricularActivity']['attachfile']['size'];
					$filetype = $this->request->data['CoCurricularActivity']['attachfile']['type'];							
					$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,doc,docx,pdf,txt');				
					if(strlen($filename1) > 0){
						$this->request->data['CoCurricularActivity']['attach_file'] = $target_path_for_database.$filename1;						
					}					
					
				}//End
			
				
			$this->CoCurricularActivity->create();
			if ($this->CoCurricularActivity->save($this->request->data)) {
				$this->Session->setFlash(__('The CoCurricularActivity has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The CoCurricularActivity could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'add'));
			}
		}
	}

	function admin_edit($id = null) {
		
		$this->layout = 'default';
		if (!$id && empty($this->request->data)) {
			$this->Session->setFlash(__('Invalid CoCurricularActivity', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->request->data)) {
		
			//Check here the File image array is empty or not
			if($this->request->data['CoCurricularActivity']['attachfile']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."news";
				$target_path_for_database ="files"."/"."news/";
				$filename = $this->request->data['CoCurricularActivity']['attachfile']['name'];
				$tmpname  = $this->request->data['CoCurricularActivity']['attachfile']['tmp_name'];
				$filesize = $this->request->data['CoCurricularActivity']['attachfile']['size'];
				$filetype = $this->request->data['CoCurricularActivity']['attachfile']['type'];							
				$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path, 'jpg,png,gif,doc,docx,pdf,txt');					
				if(strlen($filename1) > 0){
					
					if(!empty($this->request->data['CoCurricularActivity']['attach_file'])){
						if(unlink($this->request->data['CoCurricularActivity']['attach_file'])){
							$this->request->data['CoCurricularActivity']['attach_file'] = $target_path_for_database.$filename1;						
						}
					}else{
						$this->request->data['CoCurricularActivity']['attach_file'] = $target_path_for_database.$filename1;						
					}
					
				}
				
			}

			if ($this->CoCurricularActivity->save($this->request->data)) {
				$this->Session->setFlash(__('The CoCurricularActivity has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The CoCurricularActivity could not be saved. Please, try again.', true));
				$this->redirect(array('action'=>'edit',$this->request->data['CoCurricularActivity']['id']));
			}
		}
		if (empty($this->request->data)) {
			$this->request->data = $this->CoCurricularActivity->read(null, $id);
		}
	}

	function admin_delete($id = null) {
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for CoCurricularActivity', true));
			$this->redirect(array('action'=>'index'));
		}
		
		$filename = $this->CoCurricularActivity->find('first',array('conditions'=>array('CoCurricularActivity.id'=>$id),'fields'=>array('CoCurricularActivity.attach_file')));
		if(!empty($filename['CoCurricularActivity']['attach_file'])){
			if(unlink($filename['CoCurricularActivity']['attach_file'])){
				if ($this->CoCurricularActivity->delete($id)) {
					$this->Session->setFlash(__('CoCurricularActivity deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->CoCurricularActivity->delete($id)) {
					$this->Session->setFlash(__('Co Curricullar Activity deleted.', true));
					$this->redirect(array('action'=>'index'));
				}	
			}
		}else{
			if ($this->CoCurricularActivity->delete($id)) {
					$this->Session->setFlash(__('Co Curricullar Activity deleted.', true));
					$this->redirect(array('action'=>'index'));
				}	
		}
		$this->Session->setFlash(__('Co Curricullar Activity was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
	
}
?>