<?php
class CoursesController extends AppController {
	var $name = 'Courses';
	public $uses = array('Course','Download');
	public $components = array('Paginator','FileUpload');
	
	function beforeFilter(){
		parent::beforeFilter();
		//$this->Auth->allow();
	}

	function index() {
		
		$this->layout = 'inner';
		$this->Course->recursive = 0;									
		$this->set('courses', $this->Course->find('all',array('conditions' => array('Course.isactive' => 1),'order' => array('Course.order'=>'ASC'),'limit'=>10)));
		
	}
	
	function view($id = null) {
		
		$this->layout = 'inner';
		if (!$id) {
			$this->Session->setFlash(__('Invalid Course', true));
			$this->redirect(array('action' => 'index'));
		}
		$this->set('course', $this->Course->read(null, $id));
		
		$downloads = $this->Download->find('all',array('conditions'=>array('Download.course_id'=>$id,'Download.content_type'=>1)));
		$this->set('downloads', $downloads);
		
	}
	
	function admin_index() {
		$this->layout = 'default';
		$this->Course->recursive = 0;
		$this->paginate = array('order'=>'Course.created DESC');
		$this->set('courses', $this->Paginator->paginate($this->Course));
	}
    
    function admin_updateneworder($id,$order)
    {
          $this->layout = "ajax";
          $data = array('Course' => array( 'id'=> $id,'order'=>$order));   
           
        $this->Course->save($data);       
        $this->set('rowid', $id );
        $this->set('orderofrow', $order );     
    }

	function admin_add() {
		
		$this->layout = 'default';
		if (!empty($this->request->data)) {
			//Check here the File image array is empty or not
			if($this->request->data['Course']['attachfile']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."course";
				$target_path_for_database ="files"."/"."course/";
				$filename = $this->request->data['Course']['attachfile']['name'];
				$tmpname  = $this->request->data['Course']['attachfile']['tmp_name'];
				$filesize = $this->request->data['Course']['attachfile']['size'];
				$filetype = $this->request->data['Course']['attachfile']['type'];							
				$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg');				
				if(strlen($filename1) > 0){
					$this->request->data['Course']['attach_file'] = $target_path_for_database.$filename1;						
				}					
				
			}//End
			
			$this->Course->create();
			if ($this->Course->save($this->request->data)) {
				$this->Session->setFlash(__('The course has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The course could not be saved. Please, try again.', true));
				$this->redirect(array('action' => 'add'));
			}
		}
	}

	function admin_edit($id = null) {
		
		$this->layout = 'default';
		if (!$id && empty($this->request->data)) {
			$this->Session->setFlash(__('Invalid Course', true));
			$this->redirect(array('action' => 'index'));
		}
		if (!empty($this->request->data)) {
		
			//Check here the File image array is empty or not
			if($this->request->data['Course']['attachfile']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."course";
				$target_path_for_database ="files"."/"."course/";
				$filename = $this->request->data['Course']['attachfile']['name'];
				$tmpname  = $this->request->data['Course']['attachfile']['tmp_name'];
				$filesize = $this->request->data['Course']['attachfile']['size'];
				$filetype = $this->request->data['Course']['attachfile']['type'];							
				$filename1 = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path, 'jpg,png,gif,jpeg');					
				if(strlen($filename1) > 0){
					if(!empty($this->request->data['Course']['attach_file'])){
						if(unlink($this->request->data['Course']['attach_file'])){
							$this->request->data['Course']['attach_file'] = $target_path_for_database.$filename1;						
						}
					}else{
						$this->request->data['Course']['attach_file'] = $target_path_for_database.$filename1;						
					}
				}
			}
			
			if ($this->Course->save($this->request->data)) {
				$this->Session->setFlash(__('The Course has been saved', true));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The Course could not be saved. Please, try again.', true));
				$this->redirect(array('action'=>'edit',$this->request->data['Course']['id']));
			}
		}
		if (empty($this->request->data)) {
			$this->request->data = $this->Course->read(null, $id);
		}
	}

	function admin_delete($id = null) {
		
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for Course', true));
			$this->redirect(array('action'=>'index'));
		}
		
		$filename = $this->Course->find('first',array('conditions'=>array('Course.id'=>$id),'fields'=>array('Course.attach_file')));
		if(!empty($filename['Course']['attach_file'])){
			if(unlink($filename['Course']['attach_file'])){
				if ($this->Course->delete($id)) {
					$this->Session->setFlash(__('Course deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->Course->delete($id)) {
					$this->Session->setFlash(__('Course deleted.', true));
					$this->redirect(array('action'=>'index'));
				}	
			}
		}else{
			if ($this->Course->delete($id)) {
				$this->Session->setFlash(__('Course deleted.', true));
				$this->redirect(array('action'=>'index'));
			}	
		}
		$this->Session->setFlash(__('Course was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
	
}
?>