<?php
App::uses('AppController', 'Controller');

class PagesController extends AppController {

	public $uses = array('Content');
	
	public function beforeFilter(){
		parent::beforeFilter();
	} 

/**
 * Displays a view
 *
 * @param mixed What page to display
 * @return void
 * @throws NotFoundException When the view file could not be found
 *	or MissingViewException in debug mode.
 */
	public function index() {
	
		$this->layout = 'inner';
		try {
			if (isset($this->params['slug'])) {
			$page_name = $this->params['slug'];
				$this->set('title_for_layout',$page_name);
				$content = $this->Content->find('first', array('conditions' => "Content.pagealias='" . $page_name . "' and Content.isactive=1"));
			} else {
				$content = '';
			}
			$this->set('content', $content);
		} catch (MissingViewException $e) {
			if (Configure::read('debug')) {
				throw $e;
			}
			throw new NotFoundException();
		}
	}
}
