<?php
class PhotoGalleriesController extends AppController {

	public $name = 'PhotoGalleries';
	public $uses = array('PhotoGallery','PhotoCategory');
	public $components = array('FileUpload','Paginator');
	
	public function beforeFilter(){
		parent::beforeFilter();
		$this->Auth->allow('view');
	}
	
	public function index(){
		
		$this->layout = 'gallery';
		$photocategories = $this->PhotoCategory->find('all',array('conditions'=>array('PhotoCategory.isactive'=>1)));
		$this->set('photocategories',$photocategories);
		
	}
	
	public function view($catid = NULL){
		
		$this->layout = 'gallery';
		$this->paginate = array('limit'=>12);
		
		if(!empty($catid)){
			$this->PhotoGallery->recursive = 0;
			$condition = array('PhotoGallery.photo_category_id'=>$catid,'PhotoGallery.isactive'=>1);
		}else{
			$condition = '';
		}
		$photos = $this->Paginator->paginate($this->PhotoGallery,$condition);
		
		$this->set('photos',$photos);
		
	}

	public function admin_index($catid = null) {
		
		if(!empty($catid)){
			$this->PhotoGallery->recursive = 0;
			$condition = array('PhotoGallery.photo_category_id'=>$catid);
		}else{
			$condition = '';
		}
		$images = $this->paginate($this->PhotoGallery,$condition);
		$this->set('images',$images);
		
	}

	public function admin_add() {
		
		$photocategories = $this->PhotoCategory->find('list');
		$this->set('photocategories',$photocategories);
		
		if(!empty($this->request->data)) {
			
			/*========= Upload File Start=============*/
			
				if(!empty($this->request->data['PhotoGallery']['image'])){
					
					$photo_category_id = $this->request->data['PhotoGallery']['photo_category_id'];				
					
					$filearray = $this->request->data['PhotoGallery']['image'];
					
					$target_path = WWW_ROOT."files".DS."photo";
					$tpr ="files"."/"."photo/";
					$i=0;
					$allfilearray = array();
					foreach($filearray as $key=>$value):
										
						if($value['name'] != null){
											
							$filename = $value['name'];
							$tmpname = $value['tmp_name'];
							$filesize = $value['size'];
							$filetype = $value['type'];					
						
							$newfile = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,jpeg,png,gif');	
							if(strlen($newfile)>0){
								$allfilearray['PhotoGallery'][$i]['photo_category_id'] = $photo_category_id;
								$allfilearray['PhotoGallery'][$i]['imagename'] = $tpr.$newfile;
								$allfilearray['PhotoGallery'][$i]['isactive'] = 1;	
							}
						}
						$i++;
					endforeach;
				
				}
			/*========= Upload File  End=============*/
			
			if(!empty($allfilearray)){
				
				$this->PhotoGallery->create();
				if ($this->PhotoGallery->saveAll($allfilearray['PhotoGallery'])) {
					$this->Session->setFlash(__('The photo gallery has been saved', true));
					$this->redirect(array('action'=>'index'));
				} else {
					$this->Session->setFlash(__('The file type or size is not valid. Try again.'));
					$this->redirect(array('action' => 'add'));
				}
			}else {
				$this->Session->setFlash(__('The file type or size is not valid. Please, try again.'));
				$this->redirect(array('action' => 'add'));
			}
		}
	}
	
	public function admin_edit($id = null) {
		
		if (!$this->PhotoGallery->exists($id)) {
			throw new NotFoundException(__('Invalid Id'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			
			if($this->request->data['PhotoGallery']['image']['name'] != null){	
				$target_path = WWW_ROOT."files".DS."photo";
				$target_path_for_database ="files"."/"."photo/";
				
				$filename = $this->request->data['PhotoGallery']['image']['name'];
				$tmpname  = $this->request->data['PhotoGallery']['image']['tmp_name'];
				$filesize = $this->request->data['PhotoGallery']['image']['size'];
				$filetype = $this->request->data['PhotoGallery']['image']['type'];
				$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg,bmp');
				
				if(strlen($filename) > 0){
					if(!empty($this->request->data['PhotoGallery']['imagename'])){
						if(unlink($this->request->data['PhotoGallery']['imagename'])){
						$this->request->data['PhotoGallery']['imagename'] = $target_path_for_database.$filename;
						}
					}else{
						$this->request->data['PhotoGallery']['imagename'] = $target_path_for_database.$filename;
					}
				}				
			 }
			 
			if($this->PhotoGallery->save($this->request->data['PhotoGallery'])){
				$this->redirect(array('action'=>'index'));	
			}else{
				$this->Session->setFlash(__('The photo could not be edited. Please, try again.'));
				$this->redirect(array('action' => 'edit',$this->request->data['PhotoGallery']['id']));
			}
			
		}else {
			$options = array('conditions' => array('PhotoGallery.' . $this->PhotoGallery->primaryKey => $id));
			$this->request->data = $this->PhotoGallery->find('first', $options);
		}
	}
	
	public function admin_activeinactive(){
		$this->layout = 'ajax';
		$id = $this->request->params['pass'][0];
		$option = $this->request->params['pass'][1];
		$this->PhotoGallery->query('update photo_galleries set isactive = '.$option.' where id = '.$id.'');
		$this->redirect(array('action'=>'index'), null, true);
		
	}

	public function admin_delete($id = null) {
		
		if (!$id) {
			$this->Session->setFlash(__('Invalid id for photo gallery', true));
			$this->redirect(array('action'=>'index'));
		}
		
		$filename = $this->PhotoGallery->find('first',array('conditions'=>array('PhotoGallery.id'=>$id),'fields'=>array('PhotoGallery.imagename')));
		if(!empty($filename['PhotoGallery']['imagename'])){
			if(unlink($filename['PhotoGallery']['imagename'])){
				if ($this->PhotoGallery->delete($id)) {
					$this->Session->setFlash(__('Photo gallery deleted', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->PhotoGallery->delete($id)) {
					$this->Session->setFlash(__('Photo gallery deleted', true));
					$this->redirect(array('action'=>'index'));
				}	
			}
		}else{
			if ($this->PhotoGallery->delete($id)) {
				$this->Session->setFlash(__('Photo gallery deleted', true));
				$this->redirect(array('action'=>'index'));
			}	
		}
		
		$this->Session->setFlash(__('Photo gallery was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
	
}