<?php
App::uses('AppController', 'Controller');
/**
 * Studentinformations Controller
 *
 * @property Studentinformation $Studentinformation
 * @property PaginatorComponent $Paginator
 * @property FileUploadComponent $FileUpload
 */
class StudentinformationsController extends AppController {
	
	var $uses = array('Studentinformation','Download','Content','Department');

/**
 * Components
 *
 * @var array
 */
	public $components = array('Paginator', 'FileUpload');
	
	public function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow('logout');
		
	}
	
	public function logout() {
		$this->Session->destroy(); 
		$this->Session->setFlash('You have succesfully loggedout.');
		$this->redirect(array('controller' => 'studentinformations','action'=>'view'));
    }
		
/**
 * admin_index method
 *
 * @return void
 */
	public function index($classid = null, $deptid = null) {
		$this->layout = 'inner';
		$this->Studentinformation->recursive = 0;
		if($deptid == null){
			$this->set('studentinformations', $this->Studentinformation->find('all',array('conditions'=>array('Studentinformation.category_id' => $classid),'order'=>array('Studentinformation.created'=>'DESC'))));
		}else{																				
			$this->set('studentinformations', $this->Studentinformation->find('all',array('conditions'=>array('Studentinformation.category_id' => $classid,'Studentinformation.department_id' => $deptid),'order'=>array('Studentinformation.created'=>'DESC'))));
		}
		
	}

/**
 * view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function view() {
	
		$this->layout = 'inner';
		
		$content = $this->Content->find('first', array('conditions'=>array('Content.pagealias' => 'student-information')));
		$this->set('content',$content);
		
		if(!empty($this->request->data)){
			$options = array('conditions' => array('Studentinformation.studentid' => $this->request->data['Studentinformation']['studentid']));
			$studentInformation = $this->Studentinformation->find('first', $options);
			$this->set('studentinformation', $studentInformation);
			
			$this->Session->write('status','logged');
		}else{
			if($this->Session->read('status') == 'logged'){
				$this->Session->destroy(); 
			}
		
		}
	}

/**
 * admin_index method
 *
 * @return void
 */
	public function admin_index() {
		$this->Studentinformation->recursive = 0;
		$this->set('studentinformations', $this->Studentinformation->find('all',array('order'=>array('Studentinformation.created'=>'DESC'))));
	}

/**
 * admin_view method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_view($id = null) {
		if (!$this->Studentinformation->exists($id)) {
			throw new NotFoundException(__('Invalid studentinformation'));
		}
		$options = array('conditions' => array('Studentinformation.' . $this->Studentinformation->primaryKey => $id));
		$this->set('studentinformation', $this->Studentinformation->find('first', $options));
	}

/**
 * admin_edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_edit($id = null) {
		if (!$this->Studentinformation->exists($id)) {
			throw new NotFoundException(__('Invalid studentinformation'));
		}
		if ($this->request->is(array('post', 'put'))) {
			
			//Check here the File image array is empty or not
			if($this->request->data['Studentinformation']['photo']['name'] != null){				
				$target_path = WWW_ROOT."files".DS."photo";
				$target_path_for_database ="files"."/"."photo/";
				$filename = $this->request->data['Studentinformation']['photo']['name'];
				$tmpname  = $this->request->data['Studentinformation']['photo']['tmp_name'];
				$filesize = $this->request->data['Studentinformation']['photo']['size'];
				$filetype = $this->request->data['Studentinformation']['photo']['type'];							
				$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg');
				
				if(strlen($filename) > 0){
					if(!empty($this->request->data['Studentinformation']['image'])){
						if(unlink($this->request->data['Studentinformation']['image'])){
						$this->request->data['Studentinformation']['image'] = $target_path_for_database.$filename;
						}
					}else{
						$this->request->data['Studentinformation']['image'] = $target_path_for_database.$filename;
					}
				}				
				
			}//End
			
			if ($this->Studentinformation->save($this->request->data)) {
				$this->Session->setFlash(__('The studentinformation has been saved.'), 'default', array('class' => 'alert alert-success'));
				return $this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The studentinformation could not be saved. Please, try again.'), 'default', array('class' => 'alert alert-danger'));
			}
		} else {
			$options = array('conditions' => array('Studentinformation.' . $this->Studentinformation->primaryKey => $id));
			$this->request->data = $this->Studentinformation->find('first', $options);
		}
		$categories = $this->Studentinformation->Category->find('list');
		$this->set(compact('categories'));
		
		$departments = array('0'=>'Select Department/Section')+ $this->Department->find('list');
		$this->set(compact('departments'));
		
	}

/**
 * admin_delete method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_delete($id = null) {
	
		$this->Studentinformation->id = $id;
		if (!$this->Studentinformation->exists()) {
			throw new NotFoundException(__('Invalid studentinformation'));
		}
		
		$filename = $this->Studentinformation->find('first',array('conditions'=>array('Studentinformation.id'=>$id),'fields'=>array('Studentinformation.image')));
		if(!empty($filename['Studentinformation']['image'])){
			if(unlink($filename['Studentinformation']['image'])){
				if ($this->Studentinformation->delete($id)) {
					$this->Session->setFlash(__('Information deleted', true));
					$this->redirect(array('action'=>'index'));
				}
			}else{
				if ($this->Studentinformation->delete($id)) {
					$this->Session->setFlash(__('The Studentinformation has been deleted.', true));
					$this->redirect(array('action'=>'index'));
				}
			}
		}else{
			if ($this->Studentinformation->delete($id)) {
				$this->Session->setFlash(__('The Studentinformation has been deleted.', true));
				$this->redirect(array('action'=>'index'));
			}
		}
		
		$this->Session->setFlash(__('Studentinformation was not deleted', true));
		$this->redirect(array('action' => 'index'));
	}
}