<?php
App::uses('AppController', 'Controller');
/**
 * Users Controller
 *
 * @property User $User
 * @property PaginatorComponent $Paginator
 */
class UsersController extends AppController {
	
	var $uses = array('User','Group','Studentinformation','Category','Department');
	var $components = array('FileUpload');
	
	public function beforeFilter() {
		parent::beforeFilter();
		$this->Auth->allow('setACL','admin_logout','admin_login','controllerList');
	}
	
	public function setACL() {
	
		$group = $this->User->Group;
		//Allow admins to everything
		$group->id = 1;
		$this->Acl->allow($group, 'controllers');
	
		//allow managers to posts and widgets
		$group->id = 2;
		$this->Acl->deny($group, 'controllers');
		$this->Acl->allow($group, 'controllers/Users');
	
		//allow users to only add and edit on posts and widgets
		$group->id = 3;
		$this->Acl->deny($group, 'controllers');
		$this->Acl->allow($group, 'controllers/Users/admin_studentadd');
		$this->Acl->allow($group, 'controllers/Applicantinformations');
		$this->Acl->allow($group, 'controllers/Afiliations');
		$this->Acl->allow($group, 'controllers/Banners');
		$this->Acl->allow($group, 'controllers/Careers');
		$this->Acl->allow($group, 'controllers/Categories');
		$this->Acl->allow($group, 'controllers/Contents');
		$this->Acl->allow($group, 'controllers/Courses');
		$this->Acl->allow($group, 'controllers/Departments');
		$this->Acl->allow($group, 'controllers/Downloads');
		$this->Acl->allow($group, 'controllers/Employes');
		$this->Acl->allow($group, 'controllers/Faculties');
		$this->Acl->allow($group, 'controllers/Generalsettings');
		$this->Acl->allow($group, 'controllers/Homes');
		$this->Acl->allow($group, 'controllers/Libraries');
		$this->Acl->allow($group, 'controllers/Managements');
		$this->Acl->allow($group, 'controllers/Messages');
		$this->Acl->allow($group, 'controllers/News');
		$this->Acl->allow($group, 'controllers/Notices');
		$this->Acl->allow($group, 'controllers/Payments');
		$this->Acl->allow($group, 'controllers/PhotoCategories');
		$this->Acl->allow($group, 'controllers/PhotoGalleries');
		$this->Acl->allow($group, 'controllers/Results');
		$this->Acl->allow($group, 'controllers/Studentinformations');
		
		
		//allow users to only add and edit on posts and widgets
		$group->id = 5;
		$this->Acl->deny($group, 'controllers');
		$this->Acl->allow($group, 'controllers/Users');
		
		//we add an exit to avoid an ugly "missing views" error message
		echo "all done";
		exit;
	}
	
	/*public function controllerList() {

        $aCtrlClasses = App::objects('controller');

        foreach ($aCtrlClasses as $controller) {
            if ($controller != 'AppController') {
                // Load the controller
                App::import('Controller', str_replace('Controller', '', $controller));

                // Load its methods / actions
                $aMethods = get_class_methods($controller);

                foreach ($aMethods as $idx => $method) {

                    if ($method{0} == '_') {
                        unset($aMethods[$idx]);
                    }
                }

                // Load the ApplicationController (if there is one)
                App::import('Controller', 'AppController');
                $parentActions = get_class_methods('AppController');

                $controllers[$controller] = array_diff($aMethods, $parentActions);
            }
        }

        return $controllers;
    }*/

	
   public function admin_logout() {
		$this->Session->destroy(); 
		$this->Session->setFlash('You have succesfully loggedout.');
		$this->redirect(array('controller' => 'users','action'=>'login','admin'=>true));
    }

	public function admin_login() {
		
		$this->layout = 'default';
		
		if (!empty($this->request->data)) {
			
			if ($this->Auth->login()) {
				$this->redirect(array('controller' => 'homes','action'=>'index','admin'=>true));
				exit;
			} else {
				$this->Session->setFlash(__('Invalid username or password, try again'));
				$this->redirect(array('controller' => 'users','action'=>'login','admin'=>true));
			}
		}
    }
	
/**
 * admin_index method
 *
 * @return void
 */
	public function admin_index() {
		$this->User->recursive = 0;
		$this->paginate = array('conditions' => array("NOT" => array( "User.group_id" => array(1, 5))));
		$this->set('users', $this->paginate($this->User));
	}

/**
 * admin_add method
 *
 * @return void
 */
	public function admin_add() {
		
		if (!empty($this->request->data)) {
			
			$this->User->create();
			if ($this->User->save($this->request->data)) {
				$this->Session->setFlash(__('The user has been saved'));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The user could not be saved. Please, try again.'));
				$this->redirect(array('action' => 'add'));
			}
			
		}
		$this->set('groups',$this->Group->find('list',array('conditions' => array("NOT" => array( "Group.id" => array(1, 5))))));
	}

/**
 * admin_edit method
 *
 * @throws NotFoundException
 * @param string $id
 * @return void
 */
	public function admin_edit($id = null) {
		
		if (!$this->User->exists($id)) {
			throw new NotFoundException(__('Invalid user'));
		}
		if ($this->request->is('post') || $this->request->is('put')) {
			if ($this->User->save($this->request->data)) {
				$this->Session->setFlash(__('The user has been saved'));
				$this->redirect(array('action' => 'index'));
			} else {
				$this->Session->setFlash(__('The user could not be saved. Please, try again.'));
			}
		} else {
			$options = array('conditions' => array('User.' . $this->User->primaryKey => $id));
			$this->request->data = $this->User->find('first', $options);
			$this->set('groups',$this->Group->find('list',array('conditions' => array("NOT" => array( "Group.id" => array(1, 5))))));
		}
	}

/**
 * admin_delete method
 *
 * @throws NotFoundException
 * @throws MethodNotAllowedException
 * @param string $id
 * @return void
 */
	public function admin_delete($id = null) {
	
		$this->User->id = $id;
		if (!$this->User->exists()) {
			throw new NotFoundException(__('Invalid user'));
		}
		$this->request->onlyAllow('post', 'delete');
		if ($this->User->delete()) {
			$this->Session->setFlash(__('User deleted'));
			$this->redirect(array('action' => 'index'));
		}
		$this->Session->setFlash(__('User was not deleted'));
		$this->redirect(array('action' => 'index'));
	}
	
	/**

 * admin_add method
 *
 * @return void
 */
	public function admin_studentadd() {
		
		if ($this->request->is('post')) {
			$this->request->data['User']['username'] = $this->request->data['Studentinformation']['studentid'];
			$this->request->data['User']['password'] = $this->request->data['Studentinformation']['studentid'];
			$this->request->data['User']['group_id'] = 5;
			
			if ($this->User->save($this->request->data['User'])) {
				
				$this->request->data['Studentinformation']['user_id'] = $this->User->getLastInsertID();
				
				//Check here the File image array is empty or not
				if($this->request->data['Studentinformation']['photo']['name'] != null){				
					$target_path = WWW_ROOT."files".DS."photo";
					$target_path_for_database ="files"."/"."photo/";
					$filename = $this->request->data['Studentinformation']['photo']['name'];
					$tmpname  = $this->request->data['Studentinformation']['photo']['tmp_name'];
					$filesize = $this->request->data['Studentinformation']['photo']['size'];
					$filetype = $this->request->data['Studentinformation']['photo']['type'];							
					$filename = $this->FileUpload->upload($filename, $tmpname, $filesize, $target_path,'jpg,png,gif,jpeg');				
					if(strlen($filename) > 0){
						$this->request->data['Studentinformation']['image'] = $target_path_for_database.$filename;						
					}					
					
				}//End
				
				$this->Studentinformation->create();
				if ($this->Studentinformation->save($this->request->data['Studentinformation'])) {
								
					
					$this->Session->setFlash(__('The studentinformation has been saved.'), 'default', array('class' => 'alert alert-success'));
					return $this->redirect(array('controller'=>'studentinformations','action' => 'index'));
				} else {
					$this->Session->setFlash(__('The studentinformation could not be saved. Please, try again.'), 'default', array('class' => 'alert alert-danger'));
					$this->redirect(array('action' => 'studentadd'));
				}
				
			}
			
		}
		$categories = $this->Category->find('list');
		$this->set(compact('categories'));
		
		$departments = array('0'=>'Select Department/Section')+ $this->Department->find('list');
		$this->set(compact('departments'));
		
	}
	
	
}