<?php
App::uses('AppModel', 'Model');
/**
 * Department Model
 *
 * @property Department $Department
 */
class Department extends AppModel {

/**
 * Display field
 *
 * @var string
 */
	public $displayField = 'title';

/**
 * Validation rules
 *
 * @var array
 */
	public $validate = array(
		'title' => array(
			'notEmpty' => array(
				'rule' => array('notEmpty'),
				//'message' => 'Your custom message here',
				//'allowEmpty' => false,
				//'required' => false,
				//'last' => false, // Stop validation after this rule
				//'on' => 'create', // Limit validation to 'create' or 'update' operations
			),
		)
	);

	//The Associations below have been created with all possible keys, those that are not needed can be removed
	
	
/**
 * hasAndBelongsToMany associations
 *
 * @var array
 */
 
 	public $hasAndBelongsToMany = array(
        
		'Category' =>
            array(
                'className' => 'Category',
                'joinTable' => 'category_departments',
                'foreignKey' => 'category_id',
                'associationForeignKey' => 'department_id',
                'dependent' => false,
				'conditions' => '',
				'fields' => '',
				'order' => '',
				'limit' => '',
				'offset' => '',
				'exclusive' => '',
				'finderQuery' => '',
				'counterQuery' => ''
            )
    );

	public function beforeSave($options = array()){
		
		foreach (array_keys($this->hasAndBelongsToMany) as $model){
				if(isset($this->data[$this->name][$model])){
						$this->data[$model][$model] = $this->data[$this->name][$model];
						unset($this->data[$this->name][$model]);
				}
		}
		return true;
   }
	
}
